MYSQL=mysql -u rsat -D rsat -prsat -h rsat.ulb.ac.be

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' cds.mk

all: uncompress create load recompress

uncompress:
	gunzip -f ../CDS*.tab.gz

recompress:
	gzip -f ../CDS*.tab

create:
	@echo "--- Creating cds"
	cat cds_table_create.sql | ${MYSQL}

load:
	@echo "--- Loading CDS"
	grep -v '^--' ../CDS.tab > ../CDS_filtered.tab
	cat cds_table_load.ctl | ${MYSQL}
	rm ../CDS_filtered.tab
	grep -v '^--' ../CDS_function.tab > ../CDS_function_filtered.tab
	cat cds_function_table_load.ctl | ${MYSQL}
	rm ../CDS_function_filtered.tab
	grep -v '^--' ../CDS_evidence.tab > ../CDS_evidence_filtered.tab
	cat cds_evidence_table_load.ctl | ${MYSQL}
	rm ../CDS_evidence_filtered.tab
	grep -v '^--' ../CDS_exons.tab > ../CDS_exons_filtered.tab
	cat cds_exons_table_load.ctl | ${MYSQL}
	rm ../CDS_exons_filtered.tab
	grep -v '^--' ../CDS_transl_except.tab > ../CDS_transl_except_filtered.tab
	cat cds_transl_except_table_load.ctl | ${MYSQL}
	rm ../CDS_transl_except_filtered.tab
	grep -v '^--' ../CDS_names.tab > ../CDS_names_filtered.tab
	cat cds_names_table_load.ctl | ${MYSQL}
	rm ../CDS_names_filtered.tab
	grep -v '^--' ../CDS_introns.tab > ../CDS_introns_filtered.tab
	cat cds_introns_table_load.ctl | ${MYSQL}
	rm ../CDS_introns_filtered.tab
	grep -v '^--' ../CDS_note.tab > ../CDS_note_filtered.tab
	cat cds_note_table_load.ctl | ${MYSQL}
	rm ../CDS_note_filtered.tab
	grep -v '^--' ../CDS_transl_table.tab > ../CDS_transl_table_filtered.tab
	cat cds_transl_table_table_load.ctl | ${MYSQL}
	rm ../CDS_transl_table_filtered.tab
	grep -v '^--' ../CDS_db_xref.tab > ../CDS_db_xref_filtered.tab
	cat cds_db_xref_table_load.ctl | ${MYSQL}
	rm ../CDS_db_xref_filtered.tab
	grep -v '^--' ../CDS_EC_number.tab > ../CDS_EC_number_filtered.tab
	cat cds_EC_number_table_load.ctl | ${MYSQL}
	rm ../CDS_EC_number_filtered.tab

drop:
	@echo "--- Dropping cds"
	cat cds_table_drop.sql | ${MYSQL}
