
----------------------------------------------------------------
--
-- Table creation scripts for class cds
--

----------------------------------------------------------------
--
-- Schema
--
use rsat;


----------------------------------------------------------------
--
-- Main table - cds
--
CREATE TABLE cds
	(
		id                               	VARCHAR(16)	NOT NULL,
		gene                             	VARCHAR(255),
		start_pos                        	VARCHAR(255),
		taxid                            	VARCHAR(255),
		chrom_position                   	VARCHAR(255),
		codon_start                      	VARCHAR(255),
		chromosome                       	VARCHAR(255),
		strand                           	VARCHAR(255),
		translation                      	VARCHAR(255),
		organism                         	VARCHAR(255),
		contig                           	VARCHAR(255),
		gene_id                          	VARCHAR(255),
		end_pos                          	VARCHAR(255),
		protein_id                       	VARCHAR(255),
		name                             	VARCHAR(255),
		type                             	VARCHAR(255),
		product                          	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - cds_function
--
CREATE TABLE cds_function
	(
		id                               	VARCHAR(16)	NOT NULL,
		function                         	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - cds_evidence
--
CREATE TABLE cds_evidence
	(
		id                               	VARCHAR(16)	NOT NULL,
		evidence                         	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - cds_exons
--
CREATE TABLE cds_exons
	(
		id                               	VARCHAR(16)	NOT NULL,
		exons                            	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - cds_transl_except
--
CREATE TABLE cds_transl_except
	(
		id                               	VARCHAR(16)	NOT NULL,
		transl_except                    	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - cds_names
--
CREATE TABLE cds_names
	(
		id                               	VARCHAR(16)	NOT NULL,
		names                            	VARCHAR(255),
		qualifier                        	VARCHAR(20)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - cds_introns
--
CREATE TABLE cds_introns
	(
		id                               	VARCHAR(16)	NOT NULL,
		introns                          	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - cds_note
--
CREATE TABLE cds_note
	(
		id                               	VARCHAR(16)	NOT NULL,
		note                             	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - cds_transl_table
--
CREATE TABLE cds_transl_table
	(
		id                               	VARCHAR(16)	NOT NULL,
		transl_table                     	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - cds_db_xref
--
CREATE TABLE cds_db_xref
	(
		id                               	VARCHAR(16)	NOT NULL,
		db_xref                          	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - cds_EC_number
--
CREATE TABLE cds_EC_number
	(
		id                               	VARCHAR(16)	NOT NULL,
		EC_number                        	VARCHAR(255)
	)
;
