MYSQL=mysql -u rsat -D rsat -prsat -h rsat.ulb.ac.be

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' contig.mk

all: uncompress create load recompress

uncompress:
	gunzip -f ../Contig*.tab.gz

recompress:
	gzip -f ../Contig*.tab

create:
	@echo "--- Creating contig"
	cat contig_table_create.sql | ${MYSQL}

load:
	@echo "--- Loading Contig"
	grep -v '^--' ../Contig.tab > ../Contig_filtered.tab
	cat contig_table_load.ctl | ${MYSQL}
	rm ../Contig_filtered.tab
	grep -v '^--' ../Contig_names.tab > ../Contig_names_filtered.tab
	cat contig_names_table_load.ctl | ${MYSQL}
	rm ../Contig_names_filtered.tab
	grep -v '^--' ../Contig_xrefs.tab > ../Contig_xrefs_filtered.tab
	cat contig_xrefs_table_load.ctl | ${MYSQL}
	rm ../Contig_xrefs_filtered.tab

drop:
	@echo "--- Dropping contig"
	cat contig_table_drop.sql | ${MYSQL}
