
----------------------------------------------------------------
--
-- Table creation scripts for class contig
--

----------------------------------------------------------------
--
-- Schema
--
use rsat;


----------------------------------------------------------------
--
-- Main table - contig
--
CREATE TABLE contig
	(
		id                               	VARCHAR(16)	NOT NULL,
		date                             	VARCHAR(255),
		form                             	VARCHAR(255),
		file                             	VARCHAR(255),
		taxo_group                       	VARCHAR(255),
		taxid                            	VARCHAR(255),
		definition                       	VARCHAR(255),
		seq_dir                          	VARCHAR(255),
		genbank_file                     	VARCHAR(255),
		organism                         	VARCHAR(255),
		version                          	VARCHAR(255),
		accession                        	VARCHAR(255),
		length                           	VARCHAR(255),
		type                             	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - contig_names
--
CREATE TABLE contig_names
	(
		id                               	VARCHAR(16)	NOT NULL,
		names                            	VARCHAR(255),
		qualifier                        	VARCHAR(20)
	)
;

----------------------------------------------------------------
--
-- Expanded attribute - contig_xrefs
--
CREATE TABLE contig_xrefs
	(
		id                               	VARCHAR(16)	NOT NULL,
		external_db                      	VARCHAR(255),
		external_id                      	VARCHAR(255)
	)
;
