MYSQL=mysql -u rsat -D rsat -prsat -h rsat.ulb.ac.be

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' feature.mk

all: uncompress create load recompress

uncompress:
	gunzip -f ../Feature*.tab.gz

recompress:
	gzip -f ../Feature*.tab

create:
	@echo "--- Creating feature"
	cat feature_table_create.sql | ${MYSQL}

load:
	@echo "--- Loading Feature"
	grep -v '^--' ../Feature.tab > ../Feature_filtered.tab
	cat feature_table_load.ctl | ${MYSQL}
	rm ../Feature_filtered.tab
	grep -v '^--' ../Feature_names.tab > ../Feature_names_filtered.tab
	cat feature_names_table_load.ctl | ${MYSQL}
	rm ../Feature_names_filtered.tab
	grep -v '^--' ../Feature_introns.tab > ../Feature_introns_filtered.tab
	cat feature_introns_table_load.ctl | ${MYSQL}
	rm ../Feature_introns_filtered.tab
	grep -v '^--' ../Feature_exons.tab > ../Feature_exons_filtered.tab
	cat feature_exons_table_load.ctl | ${MYSQL}
	rm ../Feature_exons_filtered.tab

drop:
	@echo "--- Dropping feature"
	cat feature_table_drop.sql | ${MYSQL}
