
----------------------------------------------------------------
--
-- Table creation scripts for class feature
--

----------------------------------------------------------------
--
-- Schema
--
use rsat;


----------------------------------------------------------------
--
-- Main table - feature
--
CREATE TABLE feature
	(
		id                               	VARCHAR(16)	NOT NULL,
		type                             	VARCHAR(255),
		name                             	VARCHAR(255),
		contig                           	VARCHAR(255),
		start_pos                        	VARCHAR(255),
		end_pos                          	VARCHAR(255),
		strand                           	VARCHAR(255),
		description                      	VARCHAR(255),
		chrom_position                   	VARCHAR(255),
		organism                         	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - feature_names
--
CREATE TABLE feature_names
	(
		id                               	VARCHAR(16)	NOT NULL,
		names                            	VARCHAR(255),
		qualifier                        	VARCHAR(20)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - feature_introns
--
CREATE TABLE feature_introns
	(
		id                               	VARCHAR(16)	NOT NULL,
		introns                          	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - feature_exons
--
CREATE TABLE feature_exons
	(
		id                               	VARCHAR(16)	NOT NULL,
		exons                            	VARCHAR(255)
	)
;
