MYSQL=mysql -u rsat -D rsat -prsat -h rsat.ulb.ac.be

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' gene.mk

all: uncompress create load recompress

uncompress:
	gunzip -f ../Gene*.tab.gz

recompress:
	gzip -f ../Gene*.tab

create:
	@echo "--- Creating gene"
	cat gene_table_create.sql | ${MYSQL}

load:
	@echo "--- Loading Gene"
	grep -v '^--' ../Gene.tab > ../Gene_filtered.tab
	cat gene_table_load.ctl | ${MYSQL}
	rm ../Gene_filtered.tab
	grep -v '^--' ../Gene_evidence.tab > ../Gene_evidence_filtered.tab
	cat gene_evidence_table_load.ctl | ${MYSQL}
	rm ../Gene_evidence_filtered.tab
	grep -v '^--' ../Gene_exons.tab > ../Gene_exons_filtered.tab
	cat gene_exons_table_load.ctl | ${MYSQL}
	rm ../Gene_exons_filtered.tab
	grep -v '^--' ../Gene_names.tab > ../Gene_names_filtered.tab
	cat gene_names_table_load.ctl | ${MYSQL}
	rm ../Gene_names_filtered.tab
	grep -v '^--' ../Gene_introns.tab > ../Gene_introns_filtered.tab
	cat gene_introns_table_load.ctl | ${MYSQL}
	rm ../Gene_introns_filtered.tab
	grep -v '^--' ../Gene_note.tab > ../Gene_note_filtered.tab
	cat gene_note_table_load.ctl | ${MYSQL}
	rm ../Gene_note_filtered.tab
	grep -v '^--' ../Gene_db_xref.tab > ../Gene_db_xref_filtered.tab
	cat gene_db_xref_table_load.ctl | ${MYSQL}
	rm ../Gene_db_xref_filtered.tab

drop:
	@echo "--- Dropping gene"
	cat gene_table_drop.sql | ${MYSQL}
