
----------------------------------------------------------------
--
-- Table creation scripts for class gene
--

----------------------------------------------------------------
--
-- Schema
--
use rsat;


----------------------------------------------------------------
--
-- Main table - gene
--
CREATE TABLE gene
	(
		id                               	VARCHAR(16)	NOT NULL,
		gene                             	VARCHAR(255),
		start_pos                        	VARCHAR(255),
		taxid                            	VARCHAR(255),
		chrom_position                   	VARCHAR(255),
		chromosome                       	VARCHAR(255),
		strand                           	VARCHAR(255),
		organism                         	VARCHAR(255),
		contig                           	VARCHAR(255),
		end_pos                          	VARCHAR(255),
		name                             	VARCHAR(255),
		type                             	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - gene_evidence
--
CREATE TABLE gene_evidence
	(
		id                               	VARCHAR(16)	NOT NULL,
		evidence                         	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - gene_exons
--
CREATE TABLE gene_exons
	(
		id                               	VARCHAR(16)	NOT NULL,
		exons                            	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - gene_names
--
CREATE TABLE gene_names
	(
		id                               	VARCHAR(16)	NOT NULL,
		names                            	VARCHAR(255),
		qualifier                        	VARCHAR(20)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - gene_introns
--
CREATE TABLE gene_introns
	(
		id                               	VARCHAR(16)	NOT NULL,
		introns                          	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - gene_note
--
CREATE TABLE gene_note
	(
		id                               	VARCHAR(16)	NOT NULL,
		note                             	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - gene_db_xref
--
CREATE TABLE gene_db_xref
	(
		id                               	VARCHAR(16)	NOT NULL,
		db_xref                          	VARCHAR(255)
	)
;
