MYSQL=mysql -u rsat -D rsat -prsat -h rsat.ulb.ac.be

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' misc_feature.mk

all: uncompress create load recompress

uncompress:
	gunzip -f ../misc_feature*.tab.gz

recompress:
	gzip -f ../misc_feature*.tab

create:
	@echo "--- Creating misc_feature"
	cat misc_feature_table_create.sql | ${MYSQL}

load:
	@echo "--- Loading misc_feature"
	grep -v '^--' ../misc_feature.tab > ../misc_feature_filtered.tab
	cat misc_feature_table_load.ctl | ${MYSQL}
	rm ../misc_feature_filtered.tab
	grep -v '^--' ../misc_feature_function.tab > ../misc_feature_function_filtered.tab
	cat misc_feature_function_table_load.ctl | ${MYSQL}
	rm ../misc_feature_function_filtered.tab
	grep -v '^--' ../misc_feature_evidence.tab > ../misc_feature_evidence_filtered.tab
	cat misc_feature_evidence_table_load.ctl | ${MYSQL}
	rm ../misc_feature_evidence_filtered.tab
	grep -v '^--' ../misc_feature_names.tab > ../misc_feature_names_filtered.tab
	cat misc_feature_names_table_load.ctl | ${MYSQL}
	rm ../misc_feature_names_filtered.tab
	grep -v '^--' ../misc_feature_note.tab > ../misc_feature_note_filtered.tab
	cat misc_feature_note_table_load.ctl | ${MYSQL}
	rm ../misc_feature_note_filtered.tab
	grep -v '^--' ../misc_feature_db_xref.tab > ../misc_feature_db_xref_filtered.tab
	cat misc_feature_db_xref_table_load.ctl | ${MYSQL}
	rm ../misc_feature_db_xref_filtered.tab

drop:
	@echo "--- Dropping misc_feature"
	cat misc_feature_table_drop.sql | ${MYSQL}
