MYSQL=mysql -u rsat -D rsat -prsat -h rsat.ulb.ac.be

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' misc_rna.mk

all: uncompress create load recompress

uncompress:
	gunzip -f ../misc_RNA*.tab.gz

recompress:
	gzip -f ../misc_RNA*.tab

create:
	@echo "--- Creating misc_rna"
	cat misc_rna_table_create.sql | ${MYSQL}

load:
	@echo "--- Loading misc_RNA"
	grep -v '^--' ../misc_RNA.tab > ../misc_RNA_filtered.tab
	cat misc_rna_table_load.ctl | ${MYSQL}
	rm ../misc_RNA_filtered.tab
	grep -v '^--' ../misc_RNA_function.tab > ../misc_RNA_function_filtered.tab
	cat misc_rna_function_table_load.ctl | ${MYSQL}
	rm ../misc_RNA_function_filtered.tab
	grep -v '^--' ../misc_RNA_evidence.tab > ../misc_RNA_evidence_filtered.tab
	cat misc_rna_evidence_table_load.ctl | ${MYSQL}
	rm ../misc_RNA_evidence_filtered.tab
	grep -v '^--' ../misc_RNA_names.tab > ../misc_RNA_names_filtered.tab
	cat misc_rna_names_table_load.ctl | ${MYSQL}
	rm ../misc_RNA_names_filtered.tab
	grep -v '^--' ../misc_RNA_note.tab > ../misc_RNA_note_filtered.tab
	cat misc_rna_note_table_load.ctl | ${MYSQL}
	rm ../misc_RNA_note_filtered.tab
	grep -v '^--' ../misc_RNA_db_xref.tab > ../misc_RNA_db_xref_filtered.tab
	cat misc_rna_db_xref_table_load.ctl | ${MYSQL}
	rm ../misc_RNA_db_xref_filtered.tab

drop:
	@echo "--- Dropping misc_rna"
	cat misc_rna_table_drop.sql | ${MYSQL}
