MYSQL=mysql -u rsat -D rsat -prsat -h rsat.ulb.ac.be

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' mrna.mk

all: uncompress create load recompress

uncompress:
	gunzip -f ../mRNA*.tab.gz

recompress:
	gzip -f ../mRNA*.tab

create:
	@echo "--- Creating mrna"
	cat mrna_table_create.sql | ${MYSQL}

load:
	@echo "--- Loading mRNA"
	grep -v '^--' ../mRNA.tab > ../mRNA_filtered.tab
	cat mrna_table_load.ctl | ${MYSQL}
	rm ../mRNA_filtered.tab
	grep -v '^--' ../mRNA_note.tab > ../mRNA_note_filtered.tab
	cat mrna_note_table_load.ctl | ${MYSQL}
	rm ../mRNA_note_filtered.tab
	grep -v '^--' ../mRNA_db_xref.tab > ../mRNA_db_xref_filtered.tab
	cat mrna_db_xref_table_load.ctl | ${MYSQL}
	rm ../mRNA_db_xref_filtered.tab

drop:
	@echo "--- Dropping mrna"
	cat mrna_table_drop.sql | ${MYSQL}
