MYSQL=mysql --local-infile -u rsat -D rsat -prsat -h localhost

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' cds.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../cds*.tab.gz

recompress:
	gzip -f ../../cds*.tab

create:
	@echo "--- Creating cds"
	cat cds_table_create.sql | ${MYSQL}

alter:
	@echo "--- Alter cds"
	cat cds_table_alter.sql | ${MYSQL}

load:
	@echo "--- Loading cds"
	@if [ -f "../../cds.tab" ] ; then grep -v '^--' ../../cds.tab > ../../cds_filtered.tab ; cat cds_table_load.ctl | ${MYSQL} ; rm ../../cds_filtered.tab ; fi
	@if [ -f "../../cds_ec_number.tab" ] ; then grep -v '^--' ../../cds_ec_number.tab > ../../cds_ec_number_filtered.tab ; cat cds_ec_number_table_load.ctl | ${MYSQL} ; rm ../../cds_ec_number_filtered.tab ; fi
	@if [ -f "../../cds_db_xref.tab" ] ; then grep -v '^--' ../../cds_db_xref.tab > ../../cds_db_xref_filtered.tab ; cat cds_db_xref_table_load.ctl | ${MYSQL} ; rm ../../cds_db_xref_filtered.tab ; fi
	@if [ -f "../../cds_exons.tab" ] ; then grep -v '^--' ../../cds_exons.tab > ../../cds_exons_filtered.tab ; cat cds_exons_table_load.ctl | ${MYSQL} ; rm ../../cds_exons_filtered.tab ; fi
	@if [ -f "../../cds_function.tab" ] ; then grep -v '^--' ../../cds_function.tab > ../../cds_function_filtered.tab ; cat cds_function_table_load.ctl | ${MYSQL} ; rm ../../cds_function_filtered.tab ; fi
	@if [ -f "../../cds_gene_synonym.tab" ] ; then grep -v '^--' ../../cds_gene_synonym.tab > ../../cds_gene_synonym_filtered.tab ; cat cds_gene_synonym_table_load.ctl | ${MYSQL} ; rm ../../cds_gene_synonym_filtered.tab ; fi
	@if [ -f "../../cds_introns.tab" ] ; then grep -v '^--' ../../cds_introns.tab > ../../cds_introns_filtered.tab ; cat cds_introns_table_load.ctl | ${MYSQL} ; rm ../../cds_introns_filtered.tab ; fi
	@if [ -f "../../cds_locus_tag.tab" ] ; then grep -v '^--' ../../cds_locus_tag.tab > ../../cds_locus_tag_filtered.tab ; cat cds_locus_tag_table_load.ctl | ${MYSQL} ; rm ../../cds_locus_tag_filtered.tab ; fi
	@if [ -f "../../cds_names.tab" ] ; then grep -v '^--' ../../cds_names.tab > ../../cds_names_filtered.tab ; cat cds_names_table_load.ctl | ${MYSQL} ; rm ../../cds_names_filtered.tab ; fi
	@if [ -f "../../cds_note.tab" ] ; then grep -v '^--' ../../cds_note.tab > ../../cds_note_filtered.tab ; cat cds_note_table_load.ctl | ${MYSQL} ; rm ../../cds_note_filtered.tab ; fi
	@if [ -f "../../cds_transl_except.tab" ] ; then grep -v '^--' ../../cds_transl_except.tab > ../../cds_transl_except_filtered.tab ; cat cds_transl_except_table_load.ctl | ${MYSQL} ; rm ../../cds_transl_except_filtered.tab ; fi
	@if [ -f "../../cds_transl_table.tab" ] ; then grep -v '^--' ../../cds_transl_table.tab > ../../cds_transl_table_filtered.tab ; cat cds_transl_table_table_load.ctl | ${MYSQL} ; rm ../../cds_transl_table_filtered.tab ; fi
	@if [ -f "../../cds_translation.tab" ] ; then grep -v '^--' ../../cds_translation.tab > ../../cds_translation_filtered.tab ; cat cds_translation_table_load.ctl | ${MYSQL} ; rm ../../cds_translation_filtered.tab ; fi

drop:
	@echo "--- Dropping cds"
	cat cds_table_drop.sql | ${MYSQL}
