MYSQL=mysql --local-infile -u rsat -D rsat -prsat -h localhost

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' contig.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../contig*.tab.gz

recompress:
	gzip -f ../../contig*.tab

create:
	@echo "--- Creating contig"
	cat contig_table_create.sql | ${MYSQL}

alter:
	@echo "--- Alter contig"
	cat contig_table_alter.sql | ${MYSQL}

load:
	@echo "--- Loading contig"
	@if [ -f "../../contig.tab" ] ; then grep -v '^--' ../../contig.tab > ../../contig_filtered.tab ; cat contig_table_load.ctl | ${MYSQL} ; rm ../../contig_filtered.tab ; fi
	@if [ -f "../../contig_accession.tab" ] ; then grep -v '^--' ../../contig_accession.tab > ../../contig_accession_filtered.tab ; cat contig_accession_table_load.ctl | ${MYSQL} ; rm ../../contig_accession_filtered.tab ; fi
	@if [ -f "../../contig_comment.tab" ] ; then grep -v '^--' ../../contig_comment.tab > ../../contig_comment_filtered.tab ; cat contig_comment_table_load.ctl | ${MYSQL} ; rm ../../contig_comment_filtered.tab ; fi
	@if [ -f "../../contig_definition.tab" ] ; then grep -v '^--' ../../contig_definition.tab > ../../contig_definition_filtered.tab ; cat contig_definition_table_load.ctl | ${MYSQL} ; rm ../../contig_definition_filtered.tab ; fi
	@if [ -f "../../contig_names.tab" ] ; then grep -v '^--' ../../contig_names.tab > ../../contig_names_filtered.tab ; cat contig_names_table_load.ctl | ${MYSQL} ; rm ../../contig_names_filtered.tab ; fi
	@if [ -f "../../contig_version.tab" ] ; then grep -v '^--' ../../contig_version.tab > ../../contig_version_filtered.tab ; cat contig_version_table_load.ctl | ${MYSQL} ; rm ../../contig_version_filtered.tab ; fi
	@if [ -f "../../contig_xrefs.tab" ] ; then grep -v '^--' ../../contig_xrefs.tab > ../../contig_xrefs_filtered.tab ; cat contig_xrefs_table_load.ctl | ${MYSQL} ; rm ../../contig_xrefs_filtered.tab ; fi

drop:
	@echo "--- Dropping contig"
	cat contig_table_drop.sql | ${MYSQL}
