MYSQL=mysql --local-infile -u rsat -D rsat -prsat -h localhost

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' feature.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../feature*.tab.gz

recompress:
	gzip -f ../../feature*.tab

create:
	@echo "--- Creating feature"
	cat feature_table_create.sql | ${MYSQL}

alter:
	@echo "--- Alter feature"
	cat feature_table_alter.sql | ${MYSQL}

load:
	@echo "--- Loading feature"
	@if [ -f "../../feature.tab" ] ; then grep -v '^--' ../../feature.tab > ../../feature_filtered.tab ; cat feature_table_load.ctl | ${MYSQL} ; rm ../../feature_filtered.tab ; fi
	@if [ -f "../../feature_gene_id.tab" ] ; then grep -v '^--' ../../feature_gene_id.tab > ../../feature_gene_id_filtered.tab ; cat feature_gene_id_table_load.ctl | ${MYSQL} ; rm ../../feature_gene_id_filtered.tab ; fi
	@if [ -f "../../feature_names.tab" ] ; then grep -v '^--' ../../feature_names.tab > ../../feature_names_filtered.tab ; cat feature_names_table_load.ctl | ${MYSQL} ; rm ../../feature_names_filtered.tab ; fi
	@if [ -f "../../feature_db_xref.tab" ] ; then grep -v '^--' ../../feature_db_xref.tab > ../../feature_db_xref_filtered.tab ; cat feature_db_xref_table_load.ctl | ${MYSQL} ; rm ../../feature_db_xref_filtered.tab ; fi
	@if [ -f "../../feature_introns.tab" ] ; then grep -v '^--' ../../feature_introns.tab > ../../feature_introns_filtered.tab ; cat feature_introns_table_load.ctl | ${MYSQL} ; rm ../../feature_introns_filtered.tab ; fi
	@if [ -f "../../feature_exons.tab" ] ; then grep -v '^--' ../../feature_exons.tab > ../../feature_exons_filtered.tab ; cat feature_exons_table_load.ctl | ${MYSQL} ; rm ../../feature_exons_filtered.tab ; fi
	@if [ -f "../../feature_ec_number.tab" ] ; then grep -v '^--' ../../feature_ec_number.tab > ../../feature_ec_number_filtered.tab ; cat feature_ec_number_table_load.ctl | ${MYSQL} ; rm ../../feature_ec_number_filtered.tab ; fi

drop:
	@echo "--- Dropping feature"
	cat feature_table_drop.sql | ${MYSQL}
