MYSQL=mysql --local-infile -u rsat -D rsat -prsat -h localhost

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' gene.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../gene*.tab.gz

recompress:
	gzip -f ../../gene*.tab

create:
	@echo "--- Creating gene"
	cat gene_table_create.sql | ${MYSQL}

alter:
	@echo "--- Alter gene"
	cat gene_table_alter.sql | ${MYSQL}

load:
	@echo "--- Loading gene"
	@if [ -f "../../gene.tab" ] ; then grep -v '^--' ../../gene.tab > ../../gene_filtered.tab ; cat gene_table_load.ctl | ${MYSQL} ; rm ../../gene_filtered.tab ; fi
	@if [ -f "../../gene_db_xref.tab" ] ; then grep -v '^--' ../../gene_db_xref.tab > ../../gene_db_xref_filtered.tab ; cat gene_db_xref_table_load.ctl | ${MYSQL} ; rm ../../gene_db_xref_filtered.tab ; fi
	@if [ -f "../../gene_exons.tab" ] ; then grep -v '^--' ../../gene_exons.tab > ../../gene_exons_filtered.tab ; cat gene_exons_table_load.ctl | ${MYSQL} ; rm ../../gene_exons_filtered.tab ; fi
	@if [ -f "../../gene_gene_synonym.tab" ] ; then grep -v '^--' ../../gene_gene_synonym.tab > ../../gene_gene_synonym_filtered.tab ; cat gene_gene_synonym_table_load.ctl | ${MYSQL} ; rm ../../gene_gene_synonym_filtered.tab ; fi
	@if [ -f "../../gene_introns.tab" ] ; then grep -v '^--' ../../gene_introns.tab > ../../gene_introns_filtered.tab ; cat gene_introns_table_load.ctl | ${MYSQL} ; rm ../../gene_introns_filtered.tab ; fi
	@if [ -f "../../gene_locus_tag.tab" ] ; then grep -v '^--' ../../gene_locus_tag.tab > ../../gene_locus_tag_filtered.tab ; cat gene_locus_tag_table_load.ctl | ${MYSQL} ; rm ../../gene_locus_tag_filtered.tab ; fi
	@if [ -f "../../gene_names.tab" ] ; then grep -v '^--' ../../gene_names.tab > ../../gene_names_filtered.tab ; cat gene_names_table_load.ctl | ${MYSQL} ; rm ../../gene_names_filtered.tab ; fi
	@if [ -f "../../gene_note.tab" ] ; then grep -v '^--' ../../gene_note.tab > ../../gene_note_filtered.tab ; cat gene_note_table_load.ctl | ${MYSQL} ; rm ../../gene_note_filtered.tab ; fi

drop:
	@echo "--- Dropping gene"
	cat gene_table_drop.sql | ${MYSQL}
