
----------------------------------------------------------------
--
-- Table creation scripts for class misc_feature
--

----------------------------------------------------------------
--
-- Schema
--

----------------------------------------------------------------
--
-- Main table - misc_feature
--
CREATE TABLE misc_feature
	(
		id                               	VARCHAR(32)	NOT NULL PRIMARY KEY,
		chrom_position                   	VARCHAR(255),
		chromosome                       	VARCHAR(255),
		contig                           	VARCHAR(255),
		end_pos                          	VARCHAR(255),
		gene                             	VARCHAR(255),
		gene_id                          	VARCHAR(255),
		name                             	VARCHAR(255),
		organism                         	VARCHAR(255),
		product                          	VARCHAR(255),
		start_pos                        	VARCHAR(255),
		strand                           	VARCHAR(255),
		taxid                            	VARCHAR(255),
		type                             	VARCHAR(255)
	) TYPE=INNODB
;

----------------------------------------------------------------
--
-- Multivalue field - misc_feature_db_xref
--
CREATE TABLE misc_feature_db_xref
	(
		id                               	VARCHAR(32)	NOT NULL,
		db_xref                          	VARCHAR(255)
	) TYPE=INNODB
;
CREATE INDEX misc_feature_db_xref_id_index ON misc_feature_db_xref (id);

----------------------------------------------------------------
--
-- Multivalue field - misc_feature_function
--
CREATE TABLE misc_feature_function
	(
		id                               	VARCHAR(32)	NOT NULL,
		function                         	VARCHAR(255)
	) TYPE=INNODB
;
CREATE INDEX misc_feature_function_id_index ON misc_feature_function (id);

----------------------------------------------------------------
--
-- Multivalue field - misc_feature_names
--
CREATE TABLE misc_feature_names
	(
		id                               	VARCHAR(32)	NOT NULL,
		names                            	VARCHAR(255),
		qualifier                        	VARCHAR(20)
	) TYPE=INNODB
;
CREATE INDEX misc_feature_names_id_index ON misc_feature_names (id);

----------------------------------------------------------------
--
-- Multivalue field - misc_feature_note
--
CREATE TABLE misc_feature_note
	(
		id                               	VARCHAR(32)	NOT NULL,
		note                             	VARCHAR(255)
	) TYPE=INNODB
;
CREATE INDEX misc_feature_note_id_index ON misc_feature_note (id);
