MYSQL=mysql --local-infile -u rsat -D rsat -prsat -h localhost

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' misc_rna.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../misc_rna*.tab.gz

recompress:
	gzip -f ../../misc_rna*.tab

create:
	@echo "--- Creating misc_rna"
	cat misc_rna_table_create.sql | ${MYSQL}

alter:
	@echo "--- Alter misc_rna"
	cat misc_rna_table_alter.sql | ${MYSQL}

load:
	@echo "--- Loading misc_rna"
	@if [ -f "../../misc_rna.tab" ] ; then grep -v '^--' ../../misc_rna.tab > ../../misc_rna_filtered.tab ; cat misc_rna_table_load.ctl | ${MYSQL} ; rm ../../misc_rna_filtered.tab ; fi
	@if [ -f "../../misc_rna_function.tab" ] ; then grep -v '^--' ../../misc_rna_function.tab > ../../misc_rna_function_filtered.tab ; cat misc_rna_function_table_load.ctl | ${MYSQL} ; rm ../../misc_rna_function_filtered.tab ; fi
	@if [ -f "../../misc_rna_names.tab" ] ; then grep -v '^--' ../../misc_rna_names.tab > ../../misc_rna_names_filtered.tab ; cat misc_rna_names_table_load.ctl | ${MYSQL} ; rm ../../misc_rna_names_filtered.tab ; fi
	@if [ -f "../../misc_rna_note.tab" ] ; then grep -v '^--' ../../misc_rna_note.tab > ../../misc_rna_note_filtered.tab ; cat misc_rna_note_table_load.ctl | ${MYSQL} ; rm ../../misc_rna_note_filtered.tab ; fi

drop:
	@echo "--- Dropping misc_rna"
	cat misc_rna_table_drop.sql | ${MYSQL}
