MYSQL=mysql --local-infile -u rsat -D rsat -prsat -h localhost

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' mrna.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../mrna*.tab.gz

recompress:
	gzip -f ../../mrna*.tab

create:
	@echo "--- Creating mrna"
	cat mrna_table_create.sql | ${MYSQL}

alter:
	@echo "--- Alter mrna"
	cat mrna_table_alter.sql | ${MYSQL}

load:
	@echo "--- Loading mrna"
	@if [ -f "../../mrna.tab" ] ; then grep -v '^--' ../../mrna.tab > ../../mrna_filtered.tab ; cat mrna_table_load.ctl | ${MYSQL} ; rm ../../mrna_filtered.tab ; fi
	@if [ -f "../../mrna_db_xref.tab" ] ; then grep -v '^--' ../../mrna_db_xref.tab > ../../mrna_db_xref_filtered.tab ; cat mrna_db_xref_table_load.ctl | ${MYSQL} ; rm ../../mrna_db_xref_filtered.tab ; fi
	@if [ -f "../../mrna_exons.tab" ] ; then grep -v '^--' ../../mrna_exons.tab > ../../mrna_exons_filtered.tab ; cat mrna_exons_table_load.ctl | ${MYSQL} ; rm ../../mrna_exons_filtered.tab ; fi
	@if [ -f "../../mrna_gene_synonym.tab" ] ; then grep -v '^--' ../../mrna_gene_synonym.tab > ../../mrna_gene_synonym_filtered.tab ; cat mrna_gene_synonym_table_load.ctl | ${MYSQL} ; rm ../../mrna_gene_synonym_filtered.tab ; fi
	@if [ -f "../../mrna_introns.tab" ] ; then grep -v '^--' ../../mrna_introns.tab > ../../mrna_introns_filtered.tab ; cat mrna_introns_table_load.ctl | ${MYSQL} ; rm ../../mrna_introns_filtered.tab ; fi
	@if [ -f "../../mrna_locus_tag.tab" ] ; then grep -v '^--' ../../mrna_locus_tag.tab > ../../mrna_locus_tag_filtered.tab ; cat mrna_locus_tag_table_load.ctl | ${MYSQL} ; rm ../../mrna_locus_tag_filtered.tab ; fi
	@if [ -f "../../mrna_names.tab" ] ; then grep -v '^--' ../../mrna_names.tab > ../../mrna_names_filtered.tab ; cat mrna_names_table_load.ctl | ${MYSQL} ; rm ../../mrna_names_filtered.tab ; fi
	@if [ -f "../../mrna_note.tab" ] ; then grep -v '^--' ../../mrna_note.tab > ../../mrna_note_filtered.tab ; cat mrna_note_table_load.ctl | ${MYSQL} ; rm ../../mrna_note_filtered.tab ; fi

drop:
	@echo "--- Dropping mrna"
	cat mrna_table_drop.sql | ${MYSQL}
