MYSQL=mysql --local-infile -u rsat -D rsat -prsat -h localhost

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' organism.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../organism*.tab.gz

recompress:
	gzip -f ../../organism*.tab

create:
	@echo "--- Creating organism"
	cat organism_table_create.sql | ${MYSQL}

alter:
	@echo "--- Alter organism"
	cat organism_table_alter.sql | ${MYSQL}

load:
	@echo "--- Loading organism"
	@if [ -f "../../organism.tab" ] ; then grep -v '^--' ../../organism.tab > ../../organism_filtered.tab ; cat organism_table_load.ctl | ${MYSQL} ; rm ../../organism_filtered.tab ; fi

drop:
	@echo "--- Dropping organism"
	cat organism_table_drop.sql | ${MYSQL}
