MYSQL=mysql --local-infile -u rsat -D rsat -prsat -h localhost

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' repeat_region.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../repeat_region*.tab.gz

recompress:
	gzip -f ../../repeat_region*.tab

create:
	@echo "--- Creating repeat_region"
	cat repeat_region_table_create.sql | ${MYSQL}

alter:
	@echo "--- Alter repeat_region"
	cat repeat_region_table_alter.sql | ${MYSQL}

load:
	@echo "--- Loading repeat_region"
	@if [ -f "../../repeat_region.tab" ] ; then grep -v '^--' ../../repeat_region.tab > ../../repeat_region_filtered.tab ; cat repeat_region_table_load.ctl | ${MYSQL} ; rm ../../repeat_region_filtered.tab ; fi
	@if [ -f "../../repeat_region_db_xref.tab" ] ; then grep -v '^--' ../../repeat_region_db_xref.tab > ../../repeat_region_db_xref_filtered.tab ; cat repeat_region_db_xref_table_load.ctl | ${MYSQL} ; rm ../../repeat_region_db_xref_filtered.tab ; fi
	@if [ -f "../../repeat_region_note.tab" ] ; then grep -v '^--' ../../repeat_region_note.tab > ../../repeat_region_note_filtered.tab ; cat repeat_region_note_table_load.ctl | ${MYSQL} ; rm ../../repeat_region_note_filtered.tab ; fi
	@if [ -f "../../repeat_region_rpt_family.tab" ] ; then grep -v '^--' ../../repeat_region_rpt_family.tab > ../../repeat_region_rpt_family_filtered.tab ; cat repeat_region_rpt_family_table_load.ctl | ${MYSQL} ; rm ../../repeat_region_rpt_family_filtered.tab ; fi

drop:
	@echo "--- Dropping repeat_region"
	cat repeat_region_table_drop.sql | ${MYSQL}
