MYSQL=mysql --local-infile -u rsat -D rsat -prsat -h localhost

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' rrna.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../rrna*.tab.gz

recompress:
	gzip -f ../../rrna*.tab

create:
	@echo "--- Creating rrna"
	cat rrna_table_create.sql | ${MYSQL}

alter:
	@echo "--- Alter rrna"
	cat rrna_table_alter.sql | ${MYSQL}

load:
	@echo "--- Loading rrna"
	@if [ -f "../../rrna.tab" ] ; then grep -v '^--' ../../rrna.tab > ../../rrna_filtered.tab ; cat rrna_table_load.ctl | ${MYSQL} ; rm ../../rrna_filtered.tab ; fi
	@if [ -f "../../rrna_db_xref.tab" ] ; then grep -v '^--' ../../rrna_db_xref.tab > ../../rrna_db_xref_filtered.tab ; cat rrna_db_xref_table_load.ctl | ${MYSQL} ; rm ../../rrna_db_xref_filtered.tab ; fi
	@if [ -f "../../rrna_function.tab" ] ; then grep -v '^--' ../../rrna_function.tab > ../../rrna_function_filtered.tab ; cat rrna_function_table_load.ctl | ${MYSQL} ; rm ../../rrna_function_filtered.tab ; fi
	@if [ -f "../../rrna_locus_tag.tab" ] ; then grep -v '^--' ../../rrna_locus_tag.tab > ../../rrna_locus_tag_filtered.tab ; cat rrna_locus_tag_table_load.ctl | ${MYSQL} ; rm ../../rrna_locus_tag_filtered.tab ; fi
	@if [ -f "../../rrna_names.tab" ] ; then grep -v '^--' ../../rrna_names.tab > ../../rrna_names_filtered.tab ; cat rrna_names_table_load.ctl | ${MYSQL} ; rm ../../rrna_names_filtered.tab ; fi
	@if [ -f "../../rrna_note.tab" ] ; then grep -v '^--' ../../rrna_note.tab > ../../rrna_note_filtered.tab ; cat rrna_note_table_load.ctl | ${MYSQL} ; rm ../../rrna_note_filtered.tab ; fi

drop:
	@echo "--- Dropping rrna"
	cat rrna_table_drop.sql | ${MYSQL}
