MYSQL=mysql --local-infile -u rsat -D rsat -prsat -h localhost

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' scrna.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../scrna*.tab.gz

recompress:
	gzip -f ../../scrna*.tab

create:
	@echo "--- Creating scrna"
	cat scrna_table_create.sql | ${MYSQL}

alter:
	@echo "--- Alter scrna"
	cat scrna_table_alter.sql | ${MYSQL}

load:
	@echo "--- Loading scrna"
	@if [ -f "../../scrna.tab" ] ; then grep -v '^--' ../../scrna.tab > ../../scrna_filtered.tab ; cat scrna_table_load.ctl | ${MYSQL} ; rm ../../scrna_filtered.tab ; fi
	@if [ -f "../../scrna_db_xref.tab" ] ; then grep -v '^--' ../../scrna_db_xref.tab > ../../scrna_db_xref_filtered.tab ; cat scrna_db_xref_table_load.ctl | ${MYSQL} ; rm ../../scrna_db_xref_filtered.tab ; fi
	@if [ -f "../../scrna_note.tab" ] ; then grep -v '^--' ../../scrna_note.tab > ../../scrna_note_filtered.tab ; cat scrna_note_table_load.ctl | ${MYSQL} ; rm ../../scrna_note_filtered.tab ; fi

drop:
	@echo "--- Dropping scrna"
	cat scrna_table_drop.sql | ${MYSQL}
