MYSQL=mysql --local-infile -u rsat -D rsat -prsat -h localhost

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' source.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../source*.tab.gz

recompress:
	gzip -f ../../source*.tab

create:
	@echo "--- Creating source"
	cat source_table_create.sql | ${MYSQL}

alter:
	@echo "--- Alter source"
	cat source_table_alter.sql | ${MYSQL}

load:
	@echo "--- Loading source"
	@if [ -f "../../source.tab" ] ; then grep -v '^--' ../../source.tab > ../../source_filtered.tab ; cat source_table_load.ctl | ${MYSQL} ; rm ../../source_filtered.tab ; fi
	@if [ -f "../../source_db_xref.tab" ] ; then grep -v '^--' ../../source_db_xref.tab > ../../source_db_xref_filtered.tab ; cat source_db_xref_table_load.ctl | ${MYSQL} ; rm ../../source_db_xref_filtered.tab ; fi
	@if [ -f "../../source_mol_type.tab" ] ; then grep -v '^--' ../../source_mol_type.tab > ../../source_mol_type_filtered.tab ; cat source_mol_type_table_load.ctl | ${MYSQL} ; rm ../../source_mol_type_filtered.tab ; fi
	@if [ -f "../../source_note.tab" ] ; then grep -v '^--' ../../source_note.tab > ../../source_note_filtered.tab ; cat source_note_table_load.ctl | ${MYSQL} ; rm ../../source_note_filtered.tab ; fi
	@if [ -f "../../source_organelle.tab" ] ; then grep -v '^--' ../../source_organelle.tab > ../../source_organelle_filtered.tab ; cat source_organelle_table_load.ctl | ${MYSQL} ; rm ../../source_organelle_filtered.tab ; fi
	@if [ -f "../../source_transl_except.tab" ] ; then grep -v '^--' ../../source_transl_except.tab > ../../source_transl_except_filtered.tab ; cat source_transl_except_table_load.ctl | ${MYSQL} ; rm ../../source_transl_except_filtered.tab ; fi

drop:
	@echo "--- Dropping source"
	cat source_table_drop.sql | ${MYSQL}
