MYSQL=mysql --local-infile -u rsat -D rsat -prsat -h localhost

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' trna.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../trna*.tab.gz

recompress:
	gzip -f ../../trna*.tab

create:
	@echo "--- Creating trna"
	cat trna_table_create.sql | ${MYSQL}

alter:
	@echo "--- Alter trna"
	cat trna_table_alter.sql | ${MYSQL}

load:
	@echo "--- Loading trna"
	@if [ -f "../../trna.tab" ] ; then grep -v '^--' ../../trna.tab > ../../trna_filtered.tab ; cat trna_table_load.ctl | ${MYSQL} ; rm ../../trna_filtered.tab ; fi
	@if [ -f "../../trna_db_xref.tab" ] ; then grep -v '^--' ../../trna_db_xref.tab > ../../trna_db_xref_filtered.tab ; cat trna_db_xref_table_load.ctl | ${MYSQL} ; rm ../../trna_db_xref_filtered.tab ; fi
	@if [ -f "../../trna_exons.tab" ] ; then grep -v '^--' ../../trna_exons.tab > ../../trna_exons_filtered.tab ; cat trna_exons_table_load.ctl | ${MYSQL} ; rm ../../trna_exons_filtered.tab ; fi
	@if [ -f "../../trna_function.tab" ] ; then grep -v '^--' ../../trna_function.tab > ../../trna_function_filtered.tab ; cat trna_function_table_load.ctl | ${MYSQL} ; rm ../../trna_function_filtered.tab ; fi
	@if [ -f "../../trna_introns.tab" ] ; then grep -v '^--' ../../trna_introns.tab > ../../trna_introns_filtered.tab ; cat trna_introns_table_load.ctl | ${MYSQL} ; rm ../../trna_introns_filtered.tab ; fi
	@if [ -f "../../trna_locus_tag.tab" ] ; then grep -v '^--' ../../trna_locus_tag.tab > ../../trna_locus_tag_filtered.tab ; cat trna_locus_tag_table_load.ctl | ${MYSQL} ; rm ../../trna_locus_tag_filtered.tab ; fi
	@if [ -f "../../trna_names.tab" ] ; then grep -v '^--' ../../trna_names.tab > ../../trna_names_filtered.tab ; cat trna_names_table_load.ctl | ${MYSQL} ; rm ../../trna_names_filtered.tab ; fi
	@if [ -f "../../trna_note.tab" ] ; then grep -v '^--' ../../trna_note.tab > ../../trna_note_filtered.tab ; cat trna_note_table_load.ctl | ${MYSQL} ; rm ../../trna_note_filtered.tab ; fi

drop:
	@echo "--- Dropping trna"
	cat trna_table_drop.sql | ${MYSQL}
