SQLLOGIN=rsat/rsat@localhost
SQLLOADER=sqlldr userid=${SQLLOGIN}
SQLPLUS=sqlplus ${SQLLOGIN}

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' cds.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../cds*.tab.gz

recompress:
	gzip -f ../../cds*.tab

create:
	@echo "--- Creating cds"
	${SQLPLUS} < cds_table_create.sql

alter:
	@echo "--- Alter cds"
	${SQLPLUS} < cds_table_alter.sql

load:
	@echo "--- Loading cds"
	${SQLLOADER} control=cds_table_load.ctl skip=25
	${SQLLOADER} control=cds_ec_number_table_load.ctl skip=4
	${SQLLOADER} control=cds_db_xref_table_load.ctl skip=4
	${SQLLOADER} control=cds_exons_table_load.ctl skip=4
	${SQLLOADER} control=cds_function_table_load.ctl skip=4
	${SQLLOADER} control=cds_gene_synonym_table_load.ctl skip=4
	${SQLLOADER} control=cds_introns_table_load.ctl skip=4
	${SQLLOADER} control=cds_locus_tag_table_load.ctl skip=4
	${SQLLOADER} control=cds_names_table_load.ctl skip=4
	${SQLLOADER} control=cds_note_table_load.ctl skip=4
	${SQLLOADER} control=cds_transl_except_table_load.ctl skip=4
	${SQLLOADER} control=cds_transl_table_table_load.ctl skip=4
	${SQLLOADER} control=cds_translation_table_load.ctl skip=4

drop:
	@echo "--- Dropping cds"
	${SQLPLUS} < cds_table_drop.sql
