
----------------------------------------------------------------
--
-- Table creation scripts for class cds
--

----------------------------------------------------------------
--
-- Schema
--
alter session set current_schema=rsat;


----------------------------------------------------------------
--
-- Main table - cds
--
CREATE TABLE cds
	(
		id                               	VARCHAR(32)	NOT NULL PRIMARY KEY,
		gi                               	VARCHAR(255),
		geneid                           	VARCHAR(255),
		chrom_position                   	VARCHAR(255),
		chromosome                       	VARCHAR(255),
		codon_start                      	VARCHAR(255),
		contig                           	VARCHAR(255),
		description                      	VARCHAR(255),
		end_pos                          	VARCHAR(255),
		gene                             	VARCHAR(255),
		gene_id                          	VARCHAR(255),
		name                             	VARCHAR(255),
		organism                         	VARCHAR(255),
		product                          	VARCHAR(255),
		protein_id                       	VARCHAR(255),
		start_pos                        	VARCHAR(255),
		strand                           	VARCHAR(255),
		taxid                            	VARCHAR(255),
		type                             	VARCHAR(255)
	)
;
GRANT select ON cds TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - cds_ec_number
--
CREATE TABLE cds_ec_number
	(
		id                               	VARCHAR(32)	NOT NULL,
		ec_number                        	VARCHAR(255)
	)
;
CREATE INDEX cds_ec_number_id_index ON cds_ec_number (id);
GRANT select ON cds_ec_number TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - cds_db_xref
--
CREATE TABLE cds_db_xref
	(
		id                               	VARCHAR(32)	NOT NULL,
		db_xref                          	VARCHAR(255)
	)
;
CREATE INDEX cds_db_xref_id_index ON cds_db_xref (id);
GRANT select ON cds_db_xref TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - cds_exons
--
CREATE TABLE cds_exons
	(
		id                               	VARCHAR(32)	NOT NULL,
		exons                            	VARCHAR(255)
	)
;
CREATE INDEX cds_exons_id_index ON cds_exons (id);
GRANT select ON cds_exons TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - cds_function
--
CREATE TABLE cds_function
	(
		id                               	VARCHAR(32)	NOT NULL,
		function                         	VARCHAR(255)
	)
;
CREATE INDEX cds_function_id_index ON cds_function (id);
GRANT select ON cds_function TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - cds_gene_synonym
--
CREATE TABLE cds_gene_synonym
	(
		id                               	VARCHAR(32)	NOT NULL,
		gene_synonym                     	VARCHAR(255)
	)
;
CREATE INDEX cds_gene_synonym_id_index ON cds_gene_synonym (id);
GRANT select ON cds_gene_synonym TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - cds_introns
--
CREATE TABLE cds_introns
	(
		id                               	VARCHAR(32)	NOT NULL,
		introns                          	VARCHAR(255)
	)
;
CREATE INDEX cds_introns_id_index ON cds_introns (id);
GRANT select ON cds_introns TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - cds_locus_tag
--
CREATE TABLE cds_locus_tag
	(
		id                               	VARCHAR(32)	NOT NULL,
		locus_tag                        	VARCHAR(255)
	)
;
CREATE INDEX cds_locus_tag_id_index ON cds_locus_tag (id);
GRANT select ON cds_locus_tag TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - cds_names
--
CREATE TABLE cds_names
	(
		id                               	VARCHAR(32)	NOT NULL,
		names                            	VARCHAR(255),
		qualifier                        	VARCHAR(20)
	)
;
CREATE INDEX cds_names_id_index ON cds_names (id);
GRANT select ON cds_names TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - cds_note
--
CREATE TABLE cds_note
	(
		id                               	VARCHAR(32)	NOT NULL,
		note                             	VARCHAR(255)
	)
;
CREATE INDEX cds_note_id_index ON cds_note (id);
GRANT select ON cds_note TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - cds_transl_except
--
CREATE TABLE cds_transl_except
	(
		id                               	VARCHAR(32)	NOT NULL,
		transl_except                    	VARCHAR(255)
	)
;
CREATE INDEX cds_transl_except_id_index ON cds_transl_except (id);
GRANT select ON cds_transl_except TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - cds_transl_table
--
CREATE TABLE cds_transl_table
	(
		id                               	VARCHAR(32)	NOT NULL,
		transl_table                     	VARCHAR(255)
	)
;
CREATE INDEX cds_transl_table_id_index ON cds_transl_table (id);
GRANT select ON cds_transl_table TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - cds_translation
--
CREATE TABLE cds_translation
	(
		id                               	VARCHAR(32)	NOT NULL,
		translation                      	VARCHAR(255)
	)
;
CREATE INDEX cds_translation_id_index ON cds_translation (id);
GRANT select ON cds_translation TO amaze;

----------------------------------------------------------------
--
-- Quit
--
quit;