SQLLOGIN=rsat/rsat@localhost
SQLLOADER=sqlldr userid=${SQLLOGIN}
SQLPLUS=sqlplus ${SQLLOGIN}

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' contig.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../contig*.tab.gz

recompress:
	gzip -f ../../contig*.tab

create:
	@echo "--- Creating contig"
	${SQLPLUS} < contig_table_create.sql

alter:
	@echo "--- Alter contig"
	${SQLPLUS} < contig_table_alter.sql

load:
	@echo "--- Loading contig"
	${SQLLOADER} control=contig_table_load.ctl skip=19
	${SQLLOADER} control=contig_accession_table_load.ctl skip=4
	${SQLLOADER} control=contig_comment_table_load.ctl skip=4
	${SQLLOADER} control=contig_definition_table_load.ctl skip=4
	${SQLLOADER} control=contig_names_table_load.ctl skip=4
	${SQLLOADER} control=contig_version_table_load.ctl skip=4
	${SQLLOADER} control=contig_xrefs_table_load.ctl skip=4

drop:
	@echo "--- Dropping contig"
	${SQLPLUS} < contig_table_drop.sql
