SQLLOGIN=rsat/rsat@localhost
SQLLOADER=sqlldr userid=${SQLLOGIN}
SQLPLUS=sqlplus ${SQLLOGIN}

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' feature.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../feature*.tab.gz

recompress:
	gzip -f ../../feature*.tab

create:
	@echo "--- Creating feature"
	${SQLPLUS} < feature_table_create.sql

alter:
	@echo "--- Alter feature"
	${SQLPLUS} < feature_table_alter.sql

load:
	@echo "--- Loading feature"
	${SQLLOADER} control=feature_table_load.ctl skip=17
	${SQLLOADER} control=feature_gene_id_table_load.ctl skip=4
	${SQLLOADER} control=feature_names_table_load.ctl skip=4
	${SQLLOADER} control=feature_db_xref_table_load.ctl skip=4
	${SQLLOADER} control=feature_introns_table_load.ctl skip=4
	${SQLLOADER} control=feature_exons_table_load.ctl skip=4
	${SQLLOADER} control=feature_ec_number_table_load.ctl skip=4

drop:
	@echo "--- Dropping feature"
	${SQLPLUS} < feature_table_drop.sql
