SQLLOGIN=rsat/rsat@localhost
SQLLOADER=sqlldr userid=${SQLLOGIN}
SQLPLUS=sqlplus ${SQLLOGIN}

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' gene.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../gene*.tab.gz

recompress:
	gzip -f ../../gene*.tab

create:
	@echo "--- Creating gene"
	${SQLPLUS} < gene_table_create.sql

alter:
	@echo "--- Alter gene"
	${SQLPLUS} < gene_table_alter.sql

load:
	@echo "--- Loading gene"
	${SQLLOADER} control=gene_table_load.ctl skip=19
	${SQLLOADER} control=gene_db_xref_table_load.ctl skip=4
	${SQLLOADER} control=gene_exons_table_load.ctl skip=4
	${SQLLOADER} control=gene_gene_synonym_table_load.ctl skip=4
	${SQLLOADER} control=gene_introns_table_load.ctl skip=4
	${SQLLOADER} control=gene_locus_tag_table_load.ctl skip=4
	${SQLLOADER} control=gene_names_table_load.ctl skip=4
	${SQLLOADER} control=gene_note_table_load.ctl skip=4

drop:
	@echo "--- Dropping gene"
	${SQLPLUS} < gene_table_drop.sql
