SQLLOGIN=rsat/rsat@localhost
SQLLOADER=sqlldr userid=${SQLLOGIN}
SQLPLUS=sqlplus ${SQLLOGIN}

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' misc_feature.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../misc_feature*.tab.gz

recompress:
	gzip -f ../../misc_feature*.tab

create:
	@echo "--- Creating misc_feature"
	${SQLPLUS} < misc_feature_table_create.sql

alter:
	@echo "--- Alter misc_feature"
	${SQLPLUS} < misc_feature_table_alter.sql

load:
	@echo "--- Loading misc_feature"
	${SQLLOADER} control=misc_feature_table_load.ctl skip=20
	${SQLLOADER} control=misc_feature_db_xref_table_load.ctl skip=4
	${SQLLOADER} control=misc_feature_function_table_load.ctl skip=4
	${SQLLOADER} control=misc_feature_names_table_load.ctl skip=4
	${SQLLOADER} control=misc_feature_note_table_load.ctl skip=4

drop:
	@echo "--- Dropping misc_feature"
	${SQLPLUS} < misc_feature_table_drop.sql
