SQLLOGIN=rsat/rsat@localhost
SQLLOADER=sqlldr userid=${SQLLOGIN}
SQLPLUS=sqlplus ${SQLLOGIN}

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' misc_rna.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../misc_rna*.tab.gz

recompress:
	gzip -f ../../misc_rna*.tab

create:
	@echo "--- Creating misc_rna"
	${SQLPLUS} < misc_rna_table_create.sql

alter:
	@echo "--- Alter misc_rna"
	${SQLPLUS} < misc_rna_table_alter.sql

load:
	@echo "--- Loading misc_rna"
	${SQLLOADER} control=misc_rna_table_load.ctl skip=11
	${SQLLOADER} control=misc_rna_function_table_load.ctl skip=4
	${SQLLOADER} control=misc_rna_names_table_load.ctl skip=4
	${SQLLOADER} control=misc_rna_note_table_load.ctl skip=4

drop:
	@echo "--- Dropping misc_rna"
	${SQLPLUS} < misc_rna_table_drop.sql
