
----------------------------------------------------------------
--
-- Table creation scripts for class misc_rna
--

----------------------------------------------------------------
--
-- Schema
--
alter session set current_schema=rsat;


----------------------------------------------------------------
--
-- Main table - misc_rna
--
CREATE TABLE misc_rna
	(
		id                               	VARCHAR(32)	NOT NULL PRIMARY KEY,
		chrom_position                   	VARCHAR(255),
		gene                             	VARCHAR(255),
		gene_id                          	VARCHAR(255),
		product                          	VARCHAR(255)
	)
;
GRANT select ON misc_rna TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - misc_rna_function
--
CREATE TABLE misc_rna_function
	(
		id                               	VARCHAR(32)	NOT NULL,
		function                         	VARCHAR(255)
	)
;
CREATE INDEX misc_rna_function_id_index ON misc_rna_function (id);
GRANT select ON misc_rna_function TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - misc_rna_names
--
CREATE TABLE misc_rna_names
	(
		id                               	VARCHAR(32)	NOT NULL,
		names                            	VARCHAR(255),
		qualifier                        	VARCHAR(20)
	)
;
CREATE INDEX misc_rna_names_id_index ON misc_rna_names (id);
GRANT select ON misc_rna_names TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - misc_rna_note
--
CREATE TABLE misc_rna_note
	(
		id                               	VARCHAR(32)	NOT NULL,
		note                             	VARCHAR(255)
	)
;
CREATE INDEX misc_rna_note_id_index ON misc_rna_note (id);
GRANT select ON misc_rna_note TO amaze;

----------------------------------------------------------------
--
-- Quit
--
quit;