SQLLOGIN=rsat/rsat@localhost
SQLLOADER=sqlldr userid=${SQLLOGIN}
SQLPLUS=sqlplus ${SQLLOGIN}

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' mrna.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../mrna*.tab.gz

recompress:
	gzip -f ../../mrna*.tab

create:
	@echo "--- Creating mrna"
	${SQLPLUS} < mrna_table_create.sql

alter:
	@echo "--- Alter mrna"
	${SQLPLUS} < mrna_table_alter.sql

load:
	@echo "--- Loading mrna"
	${SQLLOADER} control=mrna_table_load.ctl skip=24
	${SQLLOADER} control=mrna_db_xref_table_load.ctl skip=4
	${SQLLOADER} control=mrna_exons_table_load.ctl skip=4
	${SQLLOADER} control=mrna_gene_synonym_table_load.ctl skip=4
	${SQLLOADER} control=mrna_introns_table_load.ctl skip=4
	${SQLLOADER} control=mrna_locus_tag_table_load.ctl skip=4
	${SQLLOADER} control=mrna_names_table_load.ctl skip=4
	${SQLLOADER} control=mrna_note_table_load.ctl skip=4

drop:
	@echo "--- Dropping mrna"
	${SQLPLUS} < mrna_table_drop.sql
