
----------------------------------------------------------------
--
-- Table creation scripts for class mrna
--

----------------------------------------------------------------
--
-- Schema
--
alter session set current_schema=rsat;


----------------------------------------------------------------
--
-- Main table - mrna
--
CREATE TABLE mrna
	(
		id                               	VARCHAR(32)	NOT NULL PRIMARY KEY,
		gi                               	VARCHAR(255),
		geneid                           	VARCHAR(255),
		chrom_position                   	VARCHAR(255),
		chromosome                       	VARCHAR(255),
		contig                           	VARCHAR(255),
		description                      	VARCHAR(255),
		end_pos                          	VARCHAR(255),
		gene                             	VARCHAR(255),
		gene_id                          	VARCHAR(255),
		name                             	VARCHAR(255),
		organism                         	VARCHAR(255),
		product                          	VARCHAR(255),
		start_pos                        	VARCHAR(255),
		strand                           	VARCHAR(255),
		taxid                            	VARCHAR(255),
		transcript_id                    	VARCHAR(255),
		type                             	VARCHAR(255)
	)
;
GRANT select ON mrna TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - mrna_db_xref
--
CREATE TABLE mrna_db_xref
	(
		id                               	VARCHAR(32)	NOT NULL,
		db_xref                          	VARCHAR(255)
	)
;
CREATE INDEX mrna_db_xref_id_index ON mrna_db_xref (id);
GRANT select ON mrna_db_xref TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - mrna_exons
--
CREATE TABLE mrna_exons
	(
		id                               	VARCHAR(32)	NOT NULL,
		exons                            	VARCHAR(255)
	)
;
CREATE INDEX mrna_exons_id_index ON mrna_exons (id);
GRANT select ON mrna_exons TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - mrna_gene_synonym
--
CREATE TABLE mrna_gene_synonym
	(
		id                               	VARCHAR(32)	NOT NULL,
		gene_synonym                     	VARCHAR(255)
	)
;
CREATE INDEX mrna_gene_synonym_id_index ON mrna_gene_synonym (id);
GRANT select ON mrna_gene_synonym TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - mrna_introns
--
CREATE TABLE mrna_introns
	(
		id                               	VARCHAR(32)	NOT NULL,
		introns                          	VARCHAR(255)
	)
;
CREATE INDEX mrna_introns_id_index ON mrna_introns (id);
GRANT select ON mrna_introns TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - mrna_locus_tag
--
CREATE TABLE mrna_locus_tag
	(
		id                               	VARCHAR(32)	NOT NULL,
		locus_tag                        	VARCHAR(255)
	)
;
CREATE INDEX mrna_locus_tag_id_index ON mrna_locus_tag (id);
GRANT select ON mrna_locus_tag TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - mrna_names
--
CREATE TABLE mrna_names
	(
		id                               	VARCHAR(32)	NOT NULL,
		names                            	VARCHAR(255),
		qualifier                        	VARCHAR(20)
	)
;
CREATE INDEX mrna_names_id_index ON mrna_names (id);
GRANT select ON mrna_names TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - mrna_note
--
CREATE TABLE mrna_note
	(
		id                               	VARCHAR(32)	NOT NULL,
		note                             	VARCHAR(255)
	)
;
CREATE INDEX mrna_note_id_index ON mrna_note (id);
GRANT select ON mrna_note TO amaze;

----------------------------------------------------------------
--
-- Quit
--
quit;