SQLLOGIN=rsat/rsat@localhost
SQLLOADER=sqlldr userid=${SQLLOGIN}
SQLPLUS=sqlplus ${SQLLOGIN}

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' organism.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../organism*.tab.gz

recompress:
	gzip -f ../../organism*.tab

create:
	@echo "--- Creating organism"
	${SQLPLUS} < organism_table_create.sql

alter:
	@echo "--- Alter organism"
	${SQLPLUS} < organism_table_alter.sql

load:
	@echo "--- Loading organism"
	${SQLLOADER} control=organism_table_load.ctl skip=9

drop:
	@echo "--- Dropping organism"
	${SQLPLUS} < organism_table_drop.sql
