SQLLOGIN=rsat/rsat@localhost
SQLLOADER=sqlldr userid=${SQLLOGIN}
SQLPLUS=sqlplus ${SQLLOGIN}

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' repeat_region.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../repeat_region*.tab.gz

recompress:
	gzip -f ../../repeat_region*.tab

create:
	@echo "--- Creating repeat_region"
	${SQLPLUS} < repeat_region_table_create.sql

alter:
	@echo "--- Alter repeat_region"
	${SQLPLUS} < repeat_region_table_alter.sql

load:
	@echo "--- Loading repeat_region"
	${SQLLOADER} control=repeat_region_table_load.ctl skip=16
	${SQLLOADER} control=repeat_region_db_xref_table_load.ctl skip=4
	${SQLLOADER} control=repeat_region_note_table_load.ctl skip=4
	${SQLLOADER} control=repeat_region_rpt_family_table_load.ctl skip=4

drop:
	@echo "--- Dropping repeat_region"
	${SQLPLUS} < repeat_region_table_drop.sql
