SQLLOGIN=rsat/rsat@localhost
SQLLOADER=sqlldr userid=${SQLLOGIN}
SQLPLUS=sqlplus ${SQLLOGIN}

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' rrna.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../rrna*.tab.gz

recompress:
	gzip -f ../../rrna*.tab

create:
	@echo "--- Creating rrna"
	${SQLPLUS} < rrna_table_create.sql

alter:
	@echo "--- Alter rrna"
	${SQLPLUS} < rrna_table_alter.sql

load:
	@echo "--- Loading rrna"
	${SQLLOADER} control=rrna_table_load.ctl skip=22
	${SQLLOADER} control=rrna_db_xref_table_load.ctl skip=4
	${SQLLOADER} control=rrna_function_table_load.ctl skip=4
	${SQLLOADER} control=rrna_locus_tag_table_load.ctl skip=4
	${SQLLOADER} control=rrna_names_table_load.ctl skip=4
	${SQLLOADER} control=rrna_note_table_load.ctl skip=4

drop:
	@echo "--- Dropping rrna"
	${SQLPLUS} < rrna_table_drop.sql
