
----------------------------------------------------------------
--
-- Table creation scripts for class rrna
--

----------------------------------------------------------------
--
-- Schema
--
alter session set current_schema=rsat;


----------------------------------------------------------------
--
-- Main table - rrna
--
CREATE TABLE rrna
	(
		id                               	VARCHAR(32)	NOT NULL PRIMARY KEY,
		geneid                           	VARCHAR(255),
		chrom_position                   	VARCHAR(255),
		chromosome                       	VARCHAR(255),
		contig                           	VARCHAR(255),
		description                      	VARCHAR(255),
		end_pos                          	VARCHAR(255),
		gene                             	VARCHAR(255),
		gene_id                          	VARCHAR(255),
		name                             	VARCHAR(255),
		organism                         	VARCHAR(255),
		product                          	VARCHAR(255),
		start_pos                        	VARCHAR(255),
		strand                           	VARCHAR(255),
		taxid                            	VARCHAR(255),
		type                             	VARCHAR(255)
	)
;
GRANT select ON rrna TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - rrna_db_xref
--
CREATE TABLE rrna_db_xref
	(
		id                               	VARCHAR(32)	NOT NULL,
		db_xref                          	VARCHAR(255)
	)
;
CREATE INDEX rrna_db_xref_id_index ON rrna_db_xref (id);
GRANT select ON rrna_db_xref TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - rrna_function
--
CREATE TABLE rrna_function
	(
		id                               	VARCHAR(32)	NOT NULL,
		function                         	VARCHAR(255)
	)
;
CREATE INDEX rrna_function_id_index ON rrna_function (id);
GRANT select ON rrna_function TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - rrna_locus_tag
--
CREATE TABLE rrna_locus_tag
	(
		id                               	VARCHAR(32)	NOT NULL,
		locus_tag                        	VARCHAR(255)
	)
;
CREATE INDEX rrna_locus_tag_id_index ON rrna_locus_tag (id);
GRANT select ON rrna_locus_tag TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - rrna_names
--
CREATE TABLE rrna_names
	(
		id                               	VARCHAR(32)	NOT NULL,
		names                            	VARCHAR(255),
		qualifier                        	VARCHAR(20)
	)
;
CREATE INDEX rrna_names_id_index ON rrna_names (id);
GRANT select ON rrna_names TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - rrna_note
--
CREATE TABLE rrna_note
	(
		id                               	VARCHAR(32)	NOT NULL,
		note                             	VARCHAR(255)
	)
;
CREATE INDEX rrna_note_id_index ON rrna_note (id);
GRANT select ON rrna_note TO amaze;

----------------------------------------------------------------
--
-- Quit
--
quit;