SQLLOGIN=rsat/rsat@localhost
SQLLOADER=sqlldr userid=${SQLLOGIN}
SQLPLUS=sqlplus ${SQLLOGIN}

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' scrna.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../scrna*.tab.gz

recompress:
	gzip -f ../../scrna*.tab

create:
	@echo "--- Creating scrna"
	${SQLPLUS} < scrna_table_create.sql

alter:
	@echo "--- Alter scrna"
	${SQLPLUS} < scrna_table_alter.sql

load:
	@echo "--- Loading scrna"
	${SQLLOADER} control=scrna_table_load.ctl skip=12
	${SQLLOADER} control=scrna_db_xref_table_load.ctl skip=4
	${SQLLOADER} control=scrna_note_table_load.ctl skip=4

drop:
	@echo "--- Dropping scrna"
	${SQLPLUS} < scrna_table_drop.sql
