
----------------------------------------------------------------
--
-- Table creation scripts for class scrna
--

----------------------------------------------------------------
--
-- Schema
--
alter session set current_schema=rsat;


----------------------------------------------------------------
--
-- Main table - scrna
--
CREATE TABLE scrna
	(
		id                               	VARCHAR(32)	NOT NULL PRIMARY KEY,
		chrom_position                   	VARCHAR(255),
		gene                             	VARCHAR(255),
		gene_id                          	VARCHAR(255),
		product                          	VARCHAR(255),
		transcript_id                    	VARCHAR(255)
	)
;
GRANT select ON scrna TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - scrna_db_xref
--
CREATE TABLE scrna_db_xref
	(
		id                               	VARCHAR(32)	NOT NULL,
		db_xref                          	VARCHAR(255)
	)
;
CREATE INDEX scrna_db_xref_id_index ON scrna_db_xref (id);
GRANT select ON scrna_db_xref TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - scrna_note
--
CREATE TABLE scrna_note
	(
		id                               	VARCHAR(32)	NOT NULL,
		note                             	VARCHAR(255)
	)
;
CREATE INDEX scrna_note_id_index ON scrna_note (id);
GRANT select ON scrna_note TO amaze;

----------------------------------------------------------------
--
-- Quit
--
quit;