SQLLOGIN=rsat/rsat@localhost
SQLLOADER=sqlldr userid=${SQLLOGIN}
SQLPLUS=sqlplus ${SQLLOGIN}

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' source.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../source*.tab.gz

recompress:
	gzip -f ../../source*.tab

create:
	@echo "--- Creating source"
	${SQLPLUS} < source_table_create.sql

alter:
	@echo "--- Alter source"
	${SQLPLUS} < source_table_alter.sql

load:
	@echo "--- Loading source"
	${SQLLOADER} control=source_table_load.ctl skip=18
	${SQLLOADER} control=source_db_xref_table_load.ctl skip=4
	${SQLLOADER} control=source_mol_type_table_load.ctl skip=4
	${SQLLOADER} control=source_note_table_load.ctl skip=4
	${SQLLOADER} control=source_organelle_table_load.ctl skip=4
	${SQLLOADER} control=source_transl_except_table_load.ctl skip=4

drop:
	@echo "--- Dropping source"
	${SQLPLUS} < source_table_drop.sql
