SQLLOGIN=rsat/rsat@localhost
SQLLOADER=sqlldr userid=${SQLLOGIN}
SQLPLUS=sqlplus ${SQLLOGIN}

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' trna.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../trna*.tab.gz

recompress:
	gzip -f ../../trna*.tab

create:
	@echo "--- Creating trna"
	${SQLPLUS} < trna_table_create.sql

alter:
	@echo "--- Alter trna"
	${SQLPLUS} < trna_table_alter.sql

load:
	@echo "--- Loading trna"
	${SQLLOADER} control=trna_table_load.ctl skip=22
	${SQLLOADER} control=trna_db_xref_table_load.ctl skip=4
	${SQLLOADER} control=trna_exons_table_load.ctl skip=4
	${SQLLOADER} control=trna_function_table_load.ctl skip=4
	${SQLLOADER} control=trna_introns_table_load.ctl skip=4
	${SQLLOADER} control=trna_locus_tag_table_load.ctl skip=4
	${SQLLOADER} control=trna_names_table_load.ctl skip=4
	${SQLLOADER} control=trna_note_table_load.ctl skip=4

drop:
	@echo "--- Dropping trna"
	${SQLPLUS} < trna_table_drop.sql
