
----------------------------------------------------------------
--
-- Table creation scripts for class trna
--

----------------------------------------------------------------
--
-- Schema
--
alter session set current_schema=rsat;


----------------------------------------------------------------
--
-- Main table - trna
--
CREATE TABLE trna
	(
		id                               	VARCHAR(32)	NOT NULL PRIMARY KEY,
		geneid                           	VARCHAR(255),
		chrom_position                   	VARCHAR(255),
		chromosome                       	VARCHAR(255),
		contig                           	VARCHAR(255),
		description                      	VARCHAR(255),
		end_pos                          	VARCHAR(255),
		gene                             	VARCHAR(255),
		gene_id                          	VARCHAR(255),
		name                             	VARCHAR(255),
		organism                         	VARCHAR(255),
		product                          	VARCHAR(255),
		start_pos                        	VARCHAR(255),
		strand                           	VARCHAR(255),
		taxid                            	VARCHAR(255),
		type                             	VARCHAR(255)
	)
;
GRANT select ON trna TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - trna_db_xref
--
CREATE TABLE trna_db_xref
	(
		id                               	VARCHAR(32)	NOT NULL,
		db_xref                          	VARCHAR(255)
	)
;
CREATE INDEX trna_db_xref_id_index ON trna_db_xref (id);
GRANT select ON trna_db_xref TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - trna_exons
--
CREATE TABLE trna_exons
	(
		id                               	VARCHAR(32)	NOT NULL,
		exons                            	VARCHAR(255)
	)
;
CREATE INDEX trna_exons_id_index ON trna_exons (id);
GRANT select ON trna_exons TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - trna_function
--
CREATE TABLE trna_function
	(
		id                               	VARCHAR(32)	NOT NULL,
		function                         	VARCHAR(255)
	)
;
CREATE INDEX trna_function_id_index ON trna_function (id);
GRANT select ON trna_function TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - trna_introns
--
CREATE TABLE trna_introns
	(
		id                               	VARCHAR(32)	NOT NULL,
		introns                          	VARCHAR(255)
	)
;
CREATE INDEX trna_introns_id_index ON trna_introns (id);
GRANT select ON trna_introns TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - trna_locus_tag
--
CREATE TABLE trna_locus_tag
	(
		id                               	VARCHAR(32)	NOT NULL,
		locus_tag                        	VARCHAR(255)
	)
;
CREATE INDEX trna_locus_tag_id_index ON trna_locus_tag (id);
GRANT select ON trna_locus_tag TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - trna_names
--
CREATE TABLE trna_names
	(
		id                               	VARCHAR(32)	NOT NULL,
		names                            	VARCHAR(255),
		qualifier                        	VARCHAR(20)
	)
;
CREATE INDEX trna_names_id_index ON trna_names (id);
GRANT select ON trna_names TO amaze;

----------------------------------------------------------------
--
-- Multivalue field - trna_note
--
CREATE TABLE trna_note
	(
		id                               	VARCHAR(32)	NOT NULL,
		note                             	VARCHAR(255)
	)
;
CREATE INDEX trna_note_id_index ON trna_note (id);
GRANT select ON trna_note TO amaze;

----------------------------------------------------------------
--
-- Quit
--
quit;