MYSQL=mysql -u rsat -D rsat -prsat -h rsat.ulb.ac.be

usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' organism.mk

all: uncompress create load recompress

uncompress:
	gunzip -f ../Organism*.tab.gz

recompress:
	gzip -f ../Organism*.tab

create:
	@echo "--- Creating organism"
	cat organism_table_create.sql | ${MYSQL}

load:
	@echo "--- Loading Organism"
	grep -v '^--' ../Organism.tab > ../Organism_filtered.tab
	cat organism_table_load.ctl | ${MYSQL}
	rm ../Organism_filtered.tab
	grep -v '^--' ../Organism_names.tab > ../Organism_names_filtered.tab
	cat organism_names_table_load.ctl | ${MYSQL}
	rm ../Organism_names_filtered.tab

drop:
	@echo "--- Dropping organism"
	cat organism_table_drop.sql | ${MYSQL}
