
usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' cds.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../cds*.tab.gz

recompress:
	gzip -f ../../cds*.tab

create:
	@echo "--- Creating cds"
	psql -f cds_table_create.sql -d rsat

alter:
	@echo "--- Alter cds"
	psql -f cds_table_alter.sql -d rsat

load:
	@echo "--- Loading cds"
	grep -v '^--' ../../cds.tab | psql -f cds_table_load.ctl -d rsat
	grep -v '^--' ../../cds_ec_number.tab | psql -f cds_ec_number_table_load.ctl -d rsat
	grep -v '^--' ../../cds_db_xref.tab | psql -f cds_db_xref_table_load.ctl -d rsat
	grep -v '^--' ../../cds_exons.tab | psql -f cds_exons_table_load.ctl -d rsat
	grep -v '^--' ../../cds_function.tab | psql -f cds_function_table_load.ctl -d rsat
	grep -v '^--' ../../cds_gene_synonym.tab | psql -f cds_gene_synonym_table_load.ctl -d rsat
	grep -v '^--' ../../cds_introns.tab | psql -f cds_introns_table_load.ctl -d rsat
	grep -v '^--' ../../cds_locus_tag.tab | psql -f cds_locus_tag_table_load.ctl -d rsat
	grep -v '^--' ../../cds_names.tab | psql -f cds_names_table_load.ctl -d rsat
	grep -v '^--' ../../cds_note.tab | psql -f cds_note_table_load.ctl -d rsat
	grep -v '^--' ../../cds_transl_except.tab | psql -f cds_transl_except_table_load.ctl -d rsat
	grep -v '^--' ../../cds_transl_table.tab | psql -f cds_transl_table_table_load.ctl -d rsat
	grep -v '^--' ../../cds_translation.tab | psql -f cds_translation_table_load.ctl -d rsat

drop:
	@echo "--- Dropping cds"
	psql -f cds_table_drop.sql -d rsat
