
usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' contig.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../contig*.tab.gz

recompress:
	gzip -f ../../contig*.tab

create:
	@echo "--- Creating contig"
	psql -f contig_table_create.sql -d rsat

alter:
	@echo "--- Alter contig"
	psql -f contig_table_alter.sql -d rsat

load:
	@echo "--- Loading contig"
	grep -v '^--' ../../contig.tab | psql -f contig_table_load.ctl -d rsat
	grep -v '^--' ../../contig_accession.tab | psql -f contig_accession_table_load.ctl -d rsat
	grep -v '^--' ../../contig_comment.tab | psql -f contig_comment_table_load.ctl -d rsat
	grep -v '^--' ../../contig_definition.tab | psql -f contig_definition_table_load.ctl -d rsat
	grep -v '^--' ../../contig_names.tab | psql -f contig_names_table_load.ctl -d rsat
	grep -v '^--' ../../contig_version.tab | psql -f contig_version_table_load.ctl -d rsat
	grep -v '^--' ../../contig_xrefs.tab | psql -f contig_xrefs_table_load.ctl -d rsat

drop:
	@echo "--- Dropping contig"
	psql -f contig_table_drop.sql -d rsat
