
----------------------------------------------------------------
--
-- Table creation scripts for class contig
--

----------------------------------------------------------------
--
-- Schema
--

----------------------------------------------------------------
--
-- Main table - contig
--
CREATE TABLE contig
	(
		id                               	VARCHAR(32)	NOT NULL PRIMARY KEY,
		date                             	VARCHAR(255),
		file                             	VARCHAR(255),
		form                             	VARCHAR(255),
		genbank_file                     	VARCHAR(255),
		length                           	VARCHAR(255),
		organism                         	VARCHAR(255),
		primary                          	VARCHAR(255),
		reference                        	VARCHAR(255),
		seq_dir                          	VARCHAR(255),
		taxid                            	VARCHAR(255),
		taxo_group                       	VARCHAR(255),
		type                             	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - contig_accession
--
CREATE TABLE contig_accession
	(
		id                               	VARCHAR(32)	NOT NULL,
		accession                        	VARCHAR(255)
	)
;
CREATE INDEX contig_accession_id_index ON contig_accession (id);

----------------------------------------------------------------
--
-- Multivalue field - contig_comment
--
CREATE TABLE contig_comment
	(
		id                               	VARCHAR(32)	NOT NULL,
		comment                          	VARCHAR(255)
	)
;
CREATE INDEX contig_comment_id_index ON contig_comment (id);

----------------------------------------------------------------
--
-- Multivalue field - contig_definition
--
CREATE TABLE contig_definition
	(
		id                               	VARCHAR(32)	NOT NULL,
		definition                       	VARCHAR(255)
	)
;
CREATE INDEX contig_definition_id_index ON contig_definition (id);

----------------------------------------------------------------
--
-- Multivalue field - contig_names
--
CREATE TABLE contig_names
	(
		id                               	VARCHAR(32)	NOT NULL,
		names                            	VARCHAR(255),
		qualifier                        	VARCHAR(20)
	)
;
CREATE INDEX contig_names_id_index ON contig_names (id);

----------------------------------------------------------------
--
-- Multivalue field - contig_version
--
CREATE TABLE contig_version
	(
		id                               	VARCHAR(32)	NOT NULL,
		version                          	VARCHAR(255)
	)
;
CREATE INDEX contig_version_id_index ON contig_version (id);

----------------------------------------------------------------
--
-- Expanded attribute - contig_xrefs
--
CREATE TABLE contig_xrefs
	(
		id                               	VARCHAR(32)	NOT NULL,
		external_db                      	VARCHAR(255),
		external_id                      	VARCHAR(255)
	)
;
CREATE INDEX contig_xrefs_id_index ON contig_xrefs (id);
