
usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' feature.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../feature*.tab.gz

recompress:
	gzip -f ../../feature*.tab

create:
	@echo "--- Creating feature"
	psql -f feature_table_create.sql -d rsat

alter:
	@echo "--- Alter feature"
	psql -f feature_table_alter.sql -d rsat

load:
	@echo "--- Loading feature"
	grep -v '^--' ../../feature.tab | psql -f feature_table_load.ctl -d rsat
	grep -v '^--' ../../feature_gene_id.tab | psql -f feature_gene_id_table_load.ctl -d rsat
	grep -v '^--' ../../feature_names.tab | psql -f feature_names_table_load.ctl -d rsat
	grep -v '^--' ../../feature_db_xref.tab | psql -f feature_db_xref_table_load.ctl -d rsat
	grep -v '^--' ../../feature_introns.tab | psql -f feature_introns_table_load.ctl -d rsat
	grep -v '^--' ../../feature_exons.tab | psql -f feature_exons_table_load.ctl -d rsat
	grep -v '^--' ../../feature_ec_number.tab | psql -f feature_ec_number_table_load.ctl -d rsat

drop:
	@echo "--- Dropping feature"
	psql -f feature_table_drop.sql -d rsat
