
----------------------------------------------------------------
--
-- Table creation scripts for class feature
--

----------------------------------------------------------------
--
-- Schema
--

----------------------------------------------------------------
--
-- Main table - feature
--
CREATE TABLE feature
	(
		id                               	VARCHAR(32)	NOT NULL PRIMARY KEY,
		type                             	VARCHAR(255),
		name                             	VARCHAR(255),
		contig                           	VARCHAR(255),
		start_pos                        	VARCHAR(255),
		end_pos                          	VARCHAR(255),
		strand                           	VARCHAR(255),
		description                      	VARCHAR(255),
		chrom_position                   	VARCHAR(255),
		organism                         	VARCHAR(255),
		geneid                           	VARCHAR(255)
	)
;

----------------------------------------------------------------
--
-- Multivalue field - feature_gene_id
--
CREATE TABLE feature_gene_id
	(
		id                               	VARCHAR(32)	NOT NULL,
		gene_id                          	VARCHAR(255)
	)
;
CREATE INDEX feature_gene_id_id_index ON feature_gene_id (id);

----------------------------------------------------------------
--
-- Multivalue field - feature_names
--
CREATE TABLE feature_names
	(
		id                               	VARCHAR(32)	NOT NULL,
		names                            	VARCHAR(255),
		qualifier                        	VARCHAR(20)
	)
;
CREATE INDEX feature_names_id_index ON feature_names (id);

----------------------------------------------------------------
--
-- Multivalue field - feature_db_xref
--
CREATE TABLE feature_db_xref
	(
		id                               	VARCHAR(32)	NOT NULL,
		db_xref                          	VARCHAR(255)
	)
;
CREATE INDEX feature_db_xref_id_index ON feature_db_xref (id);

----------------------------------------------------------------
--
-- Multivalue field - feature_introns
--
CREATE TABLE feature_introns
	(
		id                               	VARCHAR(32)	NOT NULL,
		introns                          	VARCHAR(255)
	)
;
CREATE INDEX feature_introns_id_index ON feature_introns (id);

----------------------------------------------------------------
--
-- Multivalue field - feature_exons
--
CREATE TABLE feature_exons
	(
		id                               	VARCHAR(32)	NOT NULL,
		exons                            	VARCHAR(255)
	)
;
CREATE INDEX feature_exons_id_index ON feature_exons (id);

----------------------------------------------------------------
--
-- Multivalue field - feature_ec_number
--
CREATE TABLE feature_ec_number
	(
		id                               	VARCHAR(32)	NOT NULL,
		ec_number                        	VARCHAR(255)
	)
;
CREATE INDEX feature_ec_number_id_index ON feature_ec_number (id);
