
usage:
	@perl -ne 'if (/^([a-z]\S+):/){ print "\t$$1\n";  }' gene.mk

all: create alter load recompress

uncompress:
	gunzip -f ../../gene*.tab.gz

recompress:
	gzip -f ../../gene*.tab

create:
	@echo "--- Creating gene"
	psql -f gene_table_create.sql -d rsat

alter:
	@echo "--- Alter gene"
	psql -f gene_table_alter.sql -d rsat

load:
	@echo "--- Loading gene"
	grep -v '^--' ../../gene.tab | psql -f gene_table_load.ctl -d rsat
	grep -v '^--' ../../gene_db_xref.tab | psql -f gene_db_xref_table_load.ctl -d rsat
	grep -v '^--' ../../gene_exons.tab | psql -f gene_exons_table_load.ctl -d rsat
	grep -v '^--' ../../gene_gene_synonym.tab | psql -f gene_gene_synonym_table_load.ctl -d rsat
	grep -v '^--' ../../gene_introns.tab | psql -f gene_introns_table_load.ctl -d rsat
	grep -v '^--' ../../gene_locus_tag.tab | psql -f gene_locus_tag_table_load.ctl -d rsat
	grep -v '^--' ../../gene_names.tab | psql -f gene_names_table_load.ctl -d rsat
	grep -v '^--' ../../gene_note.tab | psql -f gene_note_table_load.ctl -d rsat

drop:
	@echo "--- Dropping gene"
	psql -f gene_table_drop.sql -d rsat
